<?php
/**
* The header for our theme
*
* This is the template that displays all of the <head> section and everything up until <div id="content">
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package Catch Vogue
*/

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	
<?php do_action( 'wp_body_open' ); ?>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'catch-vogue' ); ?></a>

	<header id="masthead" class="site-header">
			<div class="wrapper">
				<div class="site-header-main">
					<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>

					<?php get_template_part( 'template-parts/header/site', 'navigation' ); ?>


				</div> <!-- .site-header-main -->
		

				<!-- <div id="header-navigation-area">
					
				</div> --> <!-- #header-navigation-area -->

			</div> <!-- .wrapper -->
		</header><!-- #masthead -->

		<div class="below-site-header">

			<div class="site-overlay"><span class="screen-reader-text"><?php esc_html_e( 'Site Overlay', 'catch-vogue' ); ?></span></div>




<?php
if ( has_header_image() ) {
    $header_image_data = get_theme_mod( 'header_image_data' );
    echo wp_get_attachment_image( $header_image_data->attachment_id, 'full' );
}
?>