# Contributing Guidelines

Thank you for your interest in contributing to our project. Whether it's a bug report, new feature, correction, or additional 
documentation, we greatly value feedback and contributions from our community.

Please read through this document before submitting any [issues][] or [pull requests][pull-requests] to ensure we have all the necessary 
information to effectively respond to your bug report or contribution.

Jump To:

* [Bug Reports](_#Bug-Reports_)
* [Feature Requests](_#Feature-Requests_)
* [Code Contributions](_#Code-Contributions_)
* [Code of Conduct](_#Code-of-Conduct_)
* [Security issue notifications](_#Security-issue-notifications_)
* [Licensing](_#Licensing_)



## How to contribute

*Before you send us a pull request, please be sure that:*

1. You're working from the latest source on the master branch.
1. You check existing open, and recently closed, pull requests to be sure that 
   someone else hasn't already addressed the problem.
1. You create an issue before working on a contribution that will take a significant 
   amount of your time.

*Creating a Pull Request*

1. Fork the repository.
1. In your fork, make your change in a branch that's based on this repo's master branch.
1. Commit the change to your fork, using a clear and descriptive commit message.
1. Create a pull request, answering any questions in the pull request form.

For contributions that will take a significant amount of time, open a new issue to pitch 
your idea before you get started. Explain the problem and describe the content you want to 
see added to the documentation. Let us know if you'll write it yourself or if you'd like us 
to help. We'll discuss your proposal with you and let you know whether we're likely to 
accept it.   

GitHub provides additional document on [forking a repository](https://help.github.com/articles/fork-a-repo/) and 
[creating a pull request](https://help.github.com/articles/creating-a-pull-request/).


## Bug Reports

Bug reports are accepted through the [Issues][] page.

Before Submitting:

* Do a search through the existing issues to make sure it has not already been reported. 
   If it has, comment your experience or +1 so we prioritize it.
* If possible, upgrade to the latest release of the SDK. It's possible the bug has 
   already been fixed in the latest version.

Writing the Bug Report:

Please ensure that your bug report has the following:

* A short, descriptive title. Ideally, other community members should be able to get a 
   good idea of the issue just from reading the title.
* A detailed description of the problem you're experiencing. This should include:
    * Expected behavior of the SDK and the actual behavior exhibited.
    * Any details of your application environment that may be relevant.
    * Debug information, stack trace or logs.
*  If you are able to create one, include a Minimal Working Example that reproduces the issue.
* Use Markdown to make the report easier to read; i.e. use code blocks when pasting a 
   code snippet.

## Feature Requests:

Open an [issue][] with the following:

* A short, descriptive title. Ideally, other community members should be able to get a 
   good idea of the feature just from reading the title.
* A detailed description of the the proposed feature. 
    * Why it should be added to the SDK.
    *  If possible, example code to illustrate how it should work.
* Use Markdown to make the request easier to read;
* If you intend to implement this feature, indicate that you'd like to the issue to be
   assigned to you.

## Bug Reports

Bug reports are accepted through the [Issues][] page.

Before Submitting:

* Do a search through the existing issues to make sure it has not already been reported. 
   If it has, comment your experience or +1 so we prioritize it.
* If possible, upgrade to the latest release of the SDK. It's possible the bug has 
   already been fixed in the latest version.

Writing the Bug Report:

Please ensure that your bug report has the following:

* A short, descriptive title. Ideally, other community members should be able to get a 
   good idea of the issue just from reading the title.
* A detailed description of the problem you're experiencing. This should include:
    * Expected behavior of the SDK and the actual behavior exhibited.
    * Any details of your application environment that may be relevant.
    * Debug information, stack trace or logs.
*  If you are able to create one, include a Minimal Working Example that reproduces the issue.
* Use Markdown to make the report easier to read; i.e. use code blocks when pasting a 
   code snippet.


## Code of Conduct
This project has adopted the [Amazon Open Source Code of Conduct](https://aws.github.io/code-of-conduct). 
For more information see the [Code of Conduct FAQ](https://aws.github.io/code-of-conduct-faq) or contact 
opensource-codeofconduct@amazon.com with any additional questions or comments.


## Security issue notifications
If you discover a potential security issue in this project we ask that you notify AWS/Amazon Security via our [vulnerability reporting page](http://aws.amazon.com/security/vulnerability-reporting/). Please do **not** create a public github issue.


## Licensing

See the [LICENSE](https://github.com/aws/aws-php-sns-message-validator/blob/master/LICENSE) file for our project's licensing. We will ask you to confirm the licensing of your contribution.

We may ask you to sign a [Contributor License Agreement (CLA)](http://en.wikipedia.org/wiki/Contributor_License_Agreement) for larger changes.
